package doABC;

import java.nio.*;
import java.util.*;

import FlashReader.*;

public class MetadataInfo extends SwfTools{
	
	private int id;
	public static int metadata_count;
	
	private CpoolInfo cpool;

	private int start=0;
	private int end=0;

	//struktura
	private int name;
	private int item_count;
	private ArrayList<ItemInfo> item_info = new ArrayList<ItemInfo>();//optional
	
	
	private MetadataInfo(AbcFile abc){
		super();
		this.cpool = abc.getConstant_pool();
		abc.ENmetadata_info.add(this);
		id = abc.ENmetadata_info.size()-1;
	}
	
	
	public static void metadata_info(ByteBuffer bbuf, int position, CpoolInfo cpool, AbcFile abc){
		try{
		bbuf.position(position);

		metadata_count = unsigned30int(bbuf);
		
		if (metadata_count>0){
			
			MetadataInfo metadata_info = new MetadataInfo(abc);
			
			metadata_info.start = bbuf.position();
			
			metadata_info.name = unsigned30int(bbuf);
			
			metadata_info.item_count = unsigned30int(bbuf);
			
			for (int i=0; i< metadata_info.item_count;i++)
				metadata_info.item_info.add(new ItemInfo(bbuf,cpool));
			
			metadata_info.end = bbuf.position()-1;
			
		}

		} catch (Exception e) {e.printStackTrace();}
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			for ( byte b: getUI32(name))
				result.add(b);
		
			for ( byte b: getUI32(item_count))
				result.add(b);

			for(int i =0; i < item_info.size();i++){
				for ( byte b: item_info.get(i).toByteCode())
					result.add(b);      	
			}

		return result;
	}

	
	
	//getters
	
	public int getName() {
		return name;
	}
	
	public String getName_string() {
		return cpool.getString(name);
	}

	public int getStart() {
		return start;
	}

	public int getEnd() {
		return end;
	}
	
	public ArrayList<ItemInfo> getItem_info() {
		return item_info;
	}
	
	//tostrings
	
	public String String(){
		StringBuffer wynik = new StringBuffer();
		
		wynik.append( "\n---#--- metadata_info "+SWF.msgs.getString("Position")+": " + start + "\n\n" );
		
		wynik.append( ">" + getStart() +"\n" );
		wynik.append(  "name: " +getName_string() +"\n" );
			//wynik+= "item_info: " + getItem_info() +"\n";
		wynik.append( "<" +  getEnd() +"\n" );

		wynik.append( "\n---!!--- "+SWF.msgs.getString("Position")+":  "+end );
		return wynik.toString();
	}

	public String toString(){
		String wynik ="";
		wynik+=start+ " - " + end;
		return wynik;
	}
	
	public String toString2(){
		String wynik ="";
		wynik+="metadata_info " +start+ " - " + end;
		return wynik;
	}


	public int getId() {
		return id;
	}
	
	

}
